;
;								EJEMPLO 38
;						Autor: Mikel Etxebarria
;			(c) Ingeniera de Microsistemas Programados S.L.
;						www.microcontroladores.com
;								Bilbao 2006
;
;Transmite, mediante el USART, mensajes de texto
;
		List	p=16F876A		;Tipo de procesador
		include	"P16F876A.INC"	;Definiciones de registros internos
    
;Ajusta los valores de la palabra de configuracin durante el ensamblaje:
;proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

			__config _CP_OFF&_CPD_OFF&_LVP_OFF&_WDT_OFF&_XT_OSC
                		
Delay_Cont	equ	0x20		;Variable para la temporizacin
Temporal_1	equ	0x21		;Variable temporal
Temporal_2	equ	0x22		;Variable temporal

			org	0x00		;Vector de RESET	
			goto	Inicio
			org	0x05

;******************************************************************************************
;Segn el valor contenido en el registro W, se devuelve el carcter a visualizar

Tabla_Mensajes	movwf	PCL		;Calcula el desplazamiento sobre la tabla

;***********************************************************************************
;La directiva DT genera tantas intsrucciones RETLW como bytes o caracteres contenga

Mens_0			equ	$		;Mens_0 apunta al primer carcter del mensaje 0
				dt	"Inegenieria de Microsistemas Programados S.L.",0x0d,0x0a,0x00

Mens_1			equ	$		;Mens_1 apunta al primer carcter del mensaje 1
				dt	"Alda. Mazarredo N. 47-1 dpto. 2",0x0d,0x0a,0x00

Mens_2			equ	$		;Mens_2 apunta al primer carcter del mensaje 2
				dt	"48009 Bilbao - Bizkaia",0x0d,0x0a,0x00

Mens_3			equ	$		;Mens_3 apunta al primer carcter del mensaje 3
				dt	"Tfno./Fax. 944230651 (www.microcontroladores.com)",0x0d,0x0a,0x0a,0x00

;********************************************************************************************
;Tx_Dato: Transmite va serie el dato presente en el reg. W

Tx_Dato			bcf		PIR1,TXIF	;Restaura el flag del transmisor
				movwf	TXREG		;Almacena el byte a transmitir
				bsf		STATUS,RP0
Tx_Dato_Wait	btfss	TXSTA,TRMT	;Byte transmitido ??
				goto	Tx_Dato_Wait;No, esperar
				bcf		STATUS,RP0
				return				;Si

;*********************************************************************************
;Delay_var: Esta rutina de propsito general realiza una temporizacin variable
;entre 10 mS y 2.5". Se emplea un preescaler de 256 y al TMR0 se le carga con 39. 
;La velocidad de trabajo es de 4Mhz y por tanto el TMR0 se incrementa cada 1uS. De 
;esta forma, el TMR0 debe contar 39 eventos que, con un preescaler de 256 hace una
;intervalo total de 10000 uS (39 * 256 * 1). Este intervalo de 10 mS se repite tantes veces como 
;indique la variable "Delay_cont", es por ello que el delay mnimo es de 10 mS ("Delay_cont=1) 
;y el mximo de 2.5" (Delay_cont=255).

Delay_var:		bcf		INTCON,T0IF		;Desconecta el flag de rebosamiento
				movlw	~.39		
				movwf	TMR0			;carga el TMR0 con 39
Intervalo		btfss	INTCON,T0IF		;Rebasamiento del TMR0 ??
				goto	Intervalo		;Todava no		
				decfsz	Delay_Cont,F	;Decrementa contador de intervalos
				goto	Delay_var		;Repite el intervalo de 10 mS
				return	

;*************************************************************************************
;Mensaje: Esta rutina transmite va USAR el mensaje cuyo inicio est indicado en
;el acumulador. El fin de un mensaje se determina mediante el cdigo 0x00

Mensaje        	movwf  	Temporal_1     	;Salva posicin de la tabla
Mensaje_1      	movf   	Temporal_1,W   	;Recupera posicin de la tabla
               	call   	Tabla_Mensajes 	;Busca caracter de salida
               	movwf  	Temporal_2     	;Guarda el caracter
               	movf   	Temporal_2,F
               	btfss  	STATUS,Z       	;Mira si es el ltimo
               	goto   	No_es_ultimo
               	return
No_es_ultimo   	call    Tx_Dato       	;Transmite
               	incf    Temporal_1,F   	;Siguiente caracter
               	goto    Mensaje_1

Inicio	 		clrf	PORTC		
				bsf		STATUS,RP0	;Selecciona banco 1
				movlw	b'10111111'
				movwf	TRISC		;RC7/Rx entrada, RC6/Tx salida
				movlw	b'11000111'
				movwf	OPTION_REG	;Preescaler de 256 asociado al TMR0
				movlw	b'00100100'	
				movwf	TXSTA		;TX en On, modo asncrono con 8 bits y alta velocidad
				movlw	.25
				movwf	SPBRG		;9600 baudios con Fosc=4MHz
				bcf		STATUS,RP0	;Selecciona banco 0
				bsf		RCSTA,SPEN	;USART en On       
		
Loop			movlw	Mens_0
				call	Mensaje			;Transmite el mensaje 0
				movlw	.100
				movwf	Delay_Cont
				call	Delay_var		;Temporiza 1 segundos
				movlw	Mens_1
				call	Mensaje			;Transmite mensaje 1
				movlw	.100
				movwf	Delay_Cont
				call	Delay_var		;Temporiza 1 segundos
				movlw	Mens_2
				call	Mensaje			;Transmite el mensaje 2
				movlw	.100
				movwf	Delay_Cont
				call	Delay_var		;Temporiza 1 segundos
				movlw	Mens_3
				call	Mensaje			;Transmite el mensaje 3
				movlw	.100
				movwf	Delay_Cont
				call	Delay_var		;Temporiza 1 segundos
				goto	Loop

				end						;Fin del programa fuente
